/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.queue;

import filenet.vw.api.VWExposedFieldDefinition;
import filenet.vw.api.VWQueueDefinition;
import filenet.vw.api.VWWorkBasketColumnDefinition;
import filenet.vw.api.VWWorkBasketDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.query.VWExposedFieldSelectionDialog;
import filenet.vw.toolkit.utils.query.VWFieldListRenderer;
import filenet.vw.toolkit.utils.table.VWQubbleSort;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.Locale;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableCellEditor;

class VWExposedFieldTableCellEditor
implements TableCellEditor,
ActionListener,
KeyListener {
    private static final int CLICK_COUNT_TO_START = 1;
    private static final int VALUE_NA = 0;
    private static final int VALUE_NO_CHANGE = 1;
    private static final int VALUE_UPDATED = 2;
    private VWSessionInfo m_sessionInfo = null;
    private VWQueueDefinition m_queueDef = null;
    private VWWorkBasketDefinition m_workBasketDef = null;
    private JTable m_table = null;
    private Object m_currentValue = null;
    private EventListenerList m_listenerList = new EventListenerList();
    private JPanel m_panel = null;
    private JComboBox m_fieldListEditorCombo = null;
    private JButton m_button = null;
    private boolean m_bEditing = false;
    private boolean m_bButtonClickedBeforeReady = false;
    private boolean m_editingWithDialog = false;
    private VWExposedFieldSelectionDialog m_fieldSelectionDialog = null;
    private boolean m_bUpdatingValue = false;

    public VWExposedFieldTableCellEditor(VWSessionInfo sessionInfo) {
        this.m_sessionInfo = sessionInfo;
        this.m_panel = new JPanel();
        this.m_button = new JButton(VWResource.s_dots){

            public void requestFocus() {
                if (!VWExposedFieldTableCellEditor.this.m_bEditing) {
                    VWExposedFieldTableCellEditor.this.m_bButtonClickedBeforeReady = true;
                } else {
                    super.requestFocus();
                }
            }
        };
        this.m_button.setMargin(new Insets(0, 0, 0, 0));
        this.m_button.setToolTipText(VWResource.SelectFieldFromDialog);
        this.m_fieldListEditorCombo = new JComboBox();
        this.m_fieldListEditorCombo.setRenderer(new VWFieldListRenderer());
        ComponentOrientation compOrientation = ComponentOrientation.getOrientation(Locale.getDefault());
        this.m_fieldListEditorCombo.setComponentOrientation(compOrientation);
        this.m_panel.setLayout(new BorderLayout(6, 6));
        this.m_panel.add((Component)this.m_fieldListEditorCombo, "Center");
        this.m_panel.add((Component)this.m_button, "After");
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.m_currentValue = value;
        this.m_table = table;
        if (isSelected) {
            this.m_panel.setForeground(table.getSelectionForeground());
            this.m_panel.setBackground(table.getSelectionBackground());
        } else {
            this.m_panel.setForeground(table.getForeground());
            this.m_panel.setBackground(table.getBackground());
        }
        Border border = null;
        if (isSelected) {
            border = UIManager.getBorder("Table.focusSelectedCellHighlightBorder");
        }
        if (border == null) {
            border = UIManager.getBorder("Table.focusCellHighlightBorder");
        }
        this.m_panel.setBorder(border);
        if (!isSelected && table.isCellEditable(row, column)) {
            Color col = UIManager.getColor("Table.focusCellForeground");
            if (col != null) {
                this.m_panel.setForeground(col);
            }
            if ((col = UIManager.getColor("Table.focusCellBackground")) != null) {
                this.m_panel.setBackground(col);
            }
        }
        this.addListeners();
        this.m_fieldListEditorCombo.requestFocus();
        return this.m_panel;
    }

    public void addCellEditorListener(CellEditorListener listener) {
        this.m_listenerList.add(CellEditorListener.class, listener);
    }

    public void cancelCellEditing() {
        this.removeListeners();
        this.fireEditingCanceled();
        this.m_bEditing = false;
    }

    public Object getCellEditorValue() {
        return this.m_currentValue;
    }

    public int getClickCountToStart() {
        return 1;
    }

    public boolean isCellEditable(EventObject anEvent) {
        boolean result = true;
        if (anEvent != null && anEvent instanceof MouseEvent && ((MouseEvent)anEvent).getClickCount() < 1) {
            result = false;
        }
        return result;
    }

    public void removeCellEditorListener(CellEditorListener listener) {
        this.m_listenerList.remove(CellEditorListener.class, listener);
    }

    public boolean shouldSelectCell(EventObject anEvent) {
        boolean bRetValue = true;
        if (this.isCellEditable(anEvent) && anEvent instanceof MouseEvent && (anEvent == null || ((MouseEvent)anEvent).getClickCount() >= 1)) {
            bRetValue = this.startCellEditing(anEvent);
        }
        return bRetValue;
    }

    public void setClickCountToStart(int count) {
    }

    public boolean startCellEditing(EventObject evt) {
        this.initFieldComboBox();
        this.m_bEditing = true;
        this.m_panel.updateUI();
        return true;
    }

    public boolean stopCellEditing() {
        this.updateCurrentValue();
        this.removeListeners();
        this.fireEditingStopped();
        this.m_bEditing = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.m_fieldListEditorCombo)) {
            int nResult = this.updateCurrentValue();
            if (nResult == 2) {
                this.removeListeners();
                this.fireEditingStopped();
                return;
            }
            if (nResult == 0) return;
            this.cancelCellEditing();
            return;
        }
        if (!event.getSource().equals(this.m_button)) return;
        if (this.m_bButtonClickedBeforeReady) {
            this.m_bButtonClickedBeforeReady = false;
            return;
        }
        if (this.m_editingWithDialog) {
            return;
        }
        this.updateCurrentValue();
        this.m_editingWithDialog = true;
        try {
            block9: {
                try {
                    if (this.m_fieldSelectionDialog == null) {
                        this.m_fieldSelectionDialog = new VWExposedFieldSelectionDialog(this.m_sessionInfo, true);
                    }
                    if (this.m_fieldSelectionDialog == null) break block9;
                    this.m_fieldSelectionDialog.reinitialize(this.m_queueDef, null);
                    this.m_fieldSelectionDialog.show();
                    this.updateCurrentValue();
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                    Object var4_5 = null;
                    this.m_fieldListEditorCombo.requestFocus();
                    this.m_editingWithDialog = false;
                    return;
                }
            }
            Object var4_4 = null;
            this.m_fieldListEditorCombo.requestFocus();
            this.m_editingWithDialog = false;
            return;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.m_fieldListEditorCombo.requestFocus();
            this.m_editingWithDialog = false;
            throw throwable;
        }
    }

    public void focusGained(FocusEvent event) {
    }

    public void focusLost(FocusEvent event) {
        int nResult = this.updateCurrentValue();
        if (nResult == 2) {
            this.removeListeners();
            this.fireEditingStopped();
        } else if (nResult != 0) {
            this.cancelCellEditing();
        }
    }

    public void keyPressed(KeyEvent event) {
    }

    public void keyReleased(KeyEvent event) {
    }

    public void keyTyped(KeyEvent event) {
        if (event.getSource().equals(this.m_table)) {
            this.startCellEditing(event);
            this.m_fieldListEditorCombo.requestFocus();
            return;
        }
        if (event.getKeyChar() == '\n') {
            switch (this.updateCurrentValue()) {
                case 2: {
                    this.stopCellEditing();
                    break;
                }
                case 0: {
                    this.cancelCellEditing();
                }
            }
        }
    }

    protected void setWorkBasketDefinition(VWWorkBasketDefinition workBasketDef) {
        this.m_workBasketDef = workBasketDef;
    }

    protected void setQueueDefinition(VWQueueDefinition queueDef) {
        this.m_queueDef = queueDef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int updateCurrentValue() {
        int nResult = 1;
        try {
            block9: {
                try {
                    if (this.m_bUpdatingValue) {
                        nResult = 0;
                        break block9;
                    }
                    if (this.m_editingWithDialog) {
                        if (this.m_fieldSelectionDialog != null) {
                            this.m_bUpdatingValue = true;
                            if (this.m_fieldSelectionDialog.getExitStatus() == 1) {
                                nResult = 1;
                            } else {
                                VWExposedFieldDefinition[] selectedFields = this.m_fieldSelectionDialog.getSelectedFields();
                                this.m_currentValue = selectedFields[0];
                                this.m_fieldListEditorCombo.getModel().setSelectedItem(this.m_currentValue);
                                nResult = 2;
                            }
                        }
                        break block9;
                    }
                    this.m_currentValue = this.m_fieldListEditorCombo.getSelectedItem();
                    nResult = 2;
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                    Object var4_5 = null;
                    this.m_bUpdatingValue = false;
                }
            }
            Object var4_4 = null;
            this.m_bUpdatingValue = false;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.m_bUpdatingValue = false;
            throw throwable;
        }
        return nResult;
    }

    protected void fireEditingStopped() {
        Object[] listeners = this.m_listenerList.getListenerList();
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CellEditorListener.class) continue;
            ((CellEditorListener)listeners[i + 1]).editingStopped(changeEvent);
        }
    }

    protected void fireEditingCanceled() {
        Object[] listeners = this.m_listenerList.getListenerList();
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CellEditorListener.class) continue;
            ((CellEditorListener)listeners[i + 1]).editingCanceled(changeEvent);
        }
    }

    private void addListeners() {
        if (this.m_table != null) {
            this.m_table.addKeyListener(this);
        }
        if (this.m_fieldListEditorCombo != null) {
            this.m_fieldListEditorCombo.addActionListener(this);
        }
        if (this.m_button != null) {
            this.m_button.addActionListener(this);
        }
    }

    private void removeListeners() {
        if (this.m_table != null) {
            this.m_table.removeKeyListener(this);
            this.m_table = null;
        }
        if (this.m_fieldListEditorCombo != null) {
            this.m_fieldListEditorCombo.removeActionListener(this);
        }
        if (this.m_button != null) {
            this.m_button.removeActionListener(this);
        }
    }

    private void initFieldComboBox() {
        DefaultComboBoxModel<Object> cbModel = new DefaultComboBoxModel();
        try {
            VWWorkBasketColumnDefinition[] columns;
            if (this.m_workBasketDef != null && (columns = this.m_workBasketDef.getWorkBasketColumnDefinitions()) != null && columns.length > 0) {
                Object[] fieldDefs = new VWExposedFieldDefinition[columns.length];
                for (int nIndex = 0; nIndex < columns.length; ++nIndex) {
                    fieldDefs[nIndex] = columns[nIndex].getColumn();
                }
                VWQubbleSort.sort(fieldDefs);
                cbModel = new DefaultComboBoxModel<Object>(fieldDefs);
            }
        }
        catch (Exception ex) {
            cbModel = new DefaultComboBoxModel();
        }
        if (this.m_currentValue != null && this.m_currentValue instanceof VWExposedFieldDefinition) {
            cbModel.setSelectedItem(this.m_currentValue);
        }
        this.m_fieldListEditorCombo.setModel(cbModel);
    }
}

